/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking.client;

import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.registration.ChannelAttributes;
import org.sinytra.fabric.networking_api.NeoListenableNetworkHandler;
import org.sinytra.fabric.networking_api.client.NeoClientCommonNetworking;
import org.sinytra.fabric.networking_api.client.NeoClientPlayNetworking;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class}, priority=999)
abstract class ClientPlayNetworkHandlerMixin
extends ClientCommonPacketListenerImpl
implements NeoListenableNetworkHandler {
    @Shadow
    public abstract Connection getConnection();

    protected ClientPlayNetworkHandlerMixin(Minecraft client, Connection connection, CommonListenerCookie connectionState) {
        super(client, connection, connectionState);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddon(CallbackInfo ci) {
        Connection connection = this.getConnection();
        if (connection != null && connection.channel() != null) {
            Set channels = ChannelAttributes.getOrCreateCommonChannels((Connection)connection, (ConnectionProtocol)this.protocol());
            NeoClientCommonNetworking.onRegisterPacket((ICommonPacketListener)((ClientPacketListener)this), channels);
        }
        NeoClientPlayNetworking.setTempPacketListener((ICommonPacketListener)((ClientPacketListener)this));
        ((ClientPlayConnectionEvents.Init)ClientPlayConnectionEvents.INIT.invoker()).onPlayInit((ClientPacketListener)this, this.minecraft);
    }

    @Inject(method={"handleLogin"}, at={@At(value="RETURN")})
    private void handleServerPlayReady(ClientboundLoginPacket packet, CallbackInfo ci) {
        NeoClientPlayNetworking.onServerReady((ClientPacketListener)this, this.minecraft);
    }

    @Override
    public void handleDisconnect() {
        ((ClientPlayConnectionEvents.Disconnect)ClientPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect((ClientPacketListener)this, this.minecraft);
    }
}

